### **1. Acquiring Access to a Host**

- The **most difficult stage** in an endpoint attack is gaining access to the host.
- **Goals of the Attacker**:
    - **Steal Information**: Extract sensitive data from the endpoint.
    - **Control a Host**: Remotely control a device within the network perimeter (often public servers or user workstations).
- **Challenges for the Attacker**:
    - Modern security products, strong user training, and well-designed networks make access difficult.
    - Attackers need to find just **one weakness** to succeed.

---

### **2. Methods of Acquiring Access**

#### **a) Phishing Campaigns**

- Deliver malware that collects user credentials.
- Direct users to fake portals resembling legitimate sites to steal credentials.

#### **b) Brute Force Attacks**

- Use dictionaries of common passwords from previous breaches.
- Attempt to guess passwords for known usernames or service accounts (e.g., `mysqladmin`).
- **Limitations**: Password lockout policies reduce the effectiveness of brute force.

#### **c) Password Spraying**

- Test very common passwords (e.g., `Summer2023`, `CompanyName123`) across multiple accounts.
- Avoids triggering lockout policies by using only one or two attempts per account.
- Targets weak but policy-compliant passwords.

#### **d) Exploiting Weak Web Applications**

- Attackers use web application vulnerabilities to access sensitive files (e.g., `/etc/passwd`, `/etc/shadow`) containing credential information.

---

### **3. Defensive Measures**

- Change **default credentials** and delete unnecessary service accounts.
- Enforce **strong password policies** and conduct regular audits.
- Regularly update and secure web applications to prevent vulnerabilities.

---

### **4. Exploiting the Endpoint**

- Once access is gained, attackers can:
    - **Take control of the endpoint**.
    - Use it to launch further attacks or make it part of a **botnet**.
    - Perform Distributed Denial of Service (**DDoS**) attacks or other malicious activities.

---

### **5. Understanding Botnets**

#### **a) What is a Botnet?**

- A **botnet** is a network of compromised "zombie" systems controlled by an attacker.
- Includes:
    - **Zombie Computers**: Infected devices running malicious bots.
    - **Command-and-Control (CnC) Server**: Provides instructions to zombie systems, often using Internet Relay Chat (IRC).

#### **b) Botnet Operation Steps**

1. **Infection**:
    - A botnet operator sends malicious bots to infect systems.
    - Bots are self-propagating malware capable of:
        - Logging keystrokes, stealing passwords, packet capturing, launching DoS attacks, and more.
    - Exploit vulnerabilities (e.g., back doors created by worms/viruses) to infect networks with strong perimeter controls.
2. **Connection to CnC Server**:
    - The infected host connects to the CnC server (via IRC, web servers, or encrypted channels).
3. **Command Execution**:
    - The botnet operator sends instructions to the zombies.
    - Zombies generate malicious traffic targeting victims, such as launching **DDoS attacks**.

#### **c) Communication Mechanisms**

- Bots communicate with the CnC server via:
    - IRC (Internet Relay Chat), encrypted channels, peer-to-peer networks, or even **social media platforms**.

---

### **6. Key Characteristics of Bots**

- **Versatility**: Bots are more sophisticated than worms, with advanced infection vectors.
- **Stealth**: Bots avoid detection by:
    - Operating covertly without high scan rates.
    - Infecting networks in ways that escape immediate notice.
- **Rapid Modification**: Bots can adapt within hours of a new exploit being published.